<?php
if ( !defined( 'ABSPATH' ) ) exit;

class Bizapp_Woocommerce_Webhook_Product extends Bizapp_Woocommerce_Webhook_Base implements Bizapp_Woocommerce_Webhook_Interface {

    protected $id = 'product';

    // Handle webhook request received from Bizapp
    public function handle() {

        $authentication_status = $this->verify_secret_key();

        $products = bizapp_woocommerce_get_setting( 'products' ) ?: array();

        $products_data = isset( $this->data['products'] ) ? $this->data['products'] : '';

        // Only sync selected Bizapp products with WooCommerce
        if ( $authentication_status && is_array( $products_data ) ) {
            foreach ( $products_data as $product_data ) {
                // Only schedule to sync selected Bizapp products
                if ( isset( $product_data['productsku'] ) && in_array( $product_data['productsku'], $products ) ) {
                    do_action( 'bizapp_woocommerce_sync_product', $product_data );
                }
            }
        }

        wp_send_json( array(
            'status' => 'ok',
            'authentication_status' => $authentication_status,
        ), 200 );

    }

}
new Bizapp_Woocommerce_Webhook_Product();
