<?php
/*
  Plugin Name: Codezeel Custom Widgets
  Description: Codezeel Default Homepage Slide Show for codezeel WordPress themes.
  Version: 1.0
  Author: Codezeel
  @copyright  Copyright (c) 2010 CodeZeel. 
 */
?>
<?php 
//  Creating Widget 
// Reference : http://codex.wordpress.org/Widgets_API
/**
 * Register widgetized areas, including two sidebars and four widget-ready columns in the footer.
 *
 * To override tmpmela_widgets_init() in a child theme, remove the action hook and add your own
 * function tied to the init hook.
 *
 
 * @uses register_sidebar
 */
function tmpmela_register_sidebars() {
	register_sidebar( array(
		'name' => esc_attr__( 'Header Shopping Cart Widget Area', 'playkids' ),
		'id' => 'header-widget',
		'description' => esc_attr__( 'The Cart on header', 'playkids' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s tab_content">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	register_sidebar( array(
		'name' => esc_attr__( 'Header Search Widget Area', 'playkids' ),
		'id' => 'header-search',
		'description' => esc_attr__( 'The header search widget area', 'playkids' ),
		'before_widget' => '',
		'after_widget' => " ",
		'before_title' => ' ',
		'after_title' => ' ',
	) );
	
	register_sidebar( array(
		'name' => esc_attr__( 'Footer Before Widget Area', 'playkids' ),
		'id' => 'footer-before-widget-area',
		'description' => esc_attr__( 'Footer Before Widget Area', 'playkids' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );	
	
	register_sidebar( array(
		'name' => esc_attr__( 'First Footer Widget Area', 'playkids' ),
		'id' => 'first-footer-widget-area',
		'description' => esc_attr__( 'The first footer widget area', 'playkids' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	register_sidebar( array(
		'name' => esc_attr__( 'Second Footer Widget Area', 'playkids' ),
		'id' => 'second-footer-widget-area',
		'description' => esc_attr__( 'The second footer widget area', 'playkids' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	register_sidebar( array(
		'name' => esc_attr__( 'Third Footer Widget Area', 'playkids' ),
		'id' => 'third-footer-widget-area',
		'description' => esc_attr__( 'The third footer widget area', 'playkids' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	register_sidebar( array(
		'name' => esc_attr__( 'Forth Footer Widget Area', 'playkids' ),
		'id' => 'forth-footer-widget-area',
		'description' => esc_attr__( 'The forth footer widget area', 'playkids' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );	

	register_sidebar( array(
		'name' => esc_attr__( 'Fifth Footer Widget Area', 'playkids' ),
		'id' => 'fifth-footer-widget-area',
		'description' => esc_attr__( 'The fifth footer widget area', 'playkids' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );	
	
	register_sidebar( array(
		'name' => esc_attr__( 'Payment Methods Icons Widget Area', 'playkids' ),
		'id' => 'payment-methods-widget-area',
		'description' => esc_attr__( 'Payment methods widget area', 'playkids' ),
		'before_widget' => '',
		'after_widget' => " ",
		'before_title' => ' ',
		'after_title' => ' ',
	) );
}
/**
 * Register sidebars by running tmpmela_widgets_init() on the widgets_init hook. 
 */
add_action( 'widgets_init', 'tmpmela_register_sidebars' );
get_template_part('codezeel/widgets/tmpmela-follow-us');
get_template_part('codezeel/widgets/tmpmela-footer-contactus');
get_template_part('codezeel/widgets/tmpmela-static-links');
get_template_part('codezeel/widgets/tmpmela-left-banner');
get_template_part('codezeel/widgets/tmpmela-header-contact');
get_template_part('codezeel/widgets/tmpmela-accepted-payment');
?>