<?php  // Reference:  http://codex.wordpress.org/Widgets_API
class AcceptedPaymentWidget extends WP_Widget
{
    function __construct(){
		$widget_settings = array('description' => 'Accepted Payment Widget', 'classname' => 'widgets-acceptedpayment');
		parent::__construct(false,$name='TM - Accepted Payment Widget',$widget_settings);
    }
    function widget($args, $instance){
		extract($args);
		$title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title']);
		$americanexpress = empty($instance['americanexpress']) ? '' : $instance['americanexpress'];
		$bitcoin = empty($instance['bitcoin']) ? '' : $instance['bitcoin'];
		$cash_on_delivery = empty($instance['cash_on_delivery']) ? '' : $instance['cash_on_delivery'];
		$dankort = empty($instance['dankort']) ? '' : $instance['dankort'];
		$discover = empty($instance['discover']) ? '' : $instance['discover'];
		$google = empty($instance['google']) ? '' : $instance['google'];
		$maestro = empty($instance['maestro']) ? '' : $instance['maestro'];
		$mastercard = empty($instance['mastercard']) ? '' : $instance['mastercard'];
		$paypal = empty($instance['paypal']) ? '' : $instance['paypal'];
		$visa = empty($instance['visa']) ? '' : $instance['visa'];	
		if(!empty($title)) :		
			echo balanceTags($before_title);			
		endif;
		if($title)		
		echo balanceTags($title);	
		if(!empty($title)) :			
			echo balanceTags($after_title);				
		endif;		
		?> 
		<ul class="acceptedpayment">
				<?php if(!empty($americanexpress)) : ?>
					<li class="american-express">
					</li>
				<?php endif; ?>
				<?php if(!empty($bitcoin)) : ?>
					<li class="bitcoin">
					</li>
				<?php endif; ?>
				<?php if(!empty($cash_on_delivery)) : ?>
					<li class="cash-on-delivery">
					</li>
				<?php endif; ?>
				<?php if(!empty($dankort)) : ?>
					<li class="dankort">
					</li>
				<?php endif; ?>
				<?php if(!empty($discover)) : ?>
					<li class="discover">
					</li>
				<?php endif; ?>
				<?php if(!empty($google)) : ?>
					<li class="google">
					</li>
				<?php endif; ?>
				<?php if(!empty($maestro)) : ?>
					<li class="maestro">
					</li>
				<?php endif; ?>
				<?php if(!empty($mastercard)) : ?>
					<li class="mastercard">
					</li>
				<?php endif; ?>
				<?php if(!empty($paypal)) : ?>
					<li class="paypal">
					</li>
				<?php endif; ?>
				<?php if(!empty($visa)) : ?>
					<li class="visa">
					</li>
				<?php endif; ?>
			
		</ul>
		<?php		
		echo balanceTags($after_widget);		
	}
    function update($new_instance, $old_instance){
		$instance['title'] =($new_instance['title']);
		$instance['americanexpress'] = false;
		$instance['bitcoin'] = false;
		$instance['cash_on_delivery'] = false;
		$instance['dankort'] = false;
		$instance['discover'] = false;
		$instance['google'] = false;
		$instance['maestro'] = false;
		$instance['mastercard'] = false;
		$instance['paypal'] = false;
		$instance['visa'] = false;
		if (isset($new_instance['americanexpress'])) $instance['americanexpress'] = true;
		if (isset($new_instance['bitcoin'])) $instance['bitcoin'] = true;
		if (isset($new_instance['cash_on_delivery'])) $instance['cash_on_delivery'] = true;
		if (isset($new_instance['dankort'])) $instance['dankort'] = true;
		if (isset($new_instance['discover'])) $instance['discover'] = true;
		if (isset($new_instance['google'])) $instance['google'] = true;
		if (isset($new_instance['maestro'])) $instance['maestro'] = true;
		if (isset($new_instance['mastercard'])) $instance['mastercard'] = true;
		if (isset($new_instance['paypal'])) $instance['paypal'] = true;
		if (isset($new_instance['visa'])) $instance['visa'] = true;
		return $instance;
	}
    function form($instance){
		$instance = wp_parse_args( (array) $instance, array(
		'title'=>'Payments', 		
		'americanexpress'=> '#',
		'bitcoin'=> '#',
		'cash_on_delivery'=> '#',
		'dankort'=> '#',
		'discover'=> '#',
		'google'=> '#',
		'maestro'=> '#',	
		'mastercard'=> '#',
		'paypal'=> '#',
		'visa'=> '#') );	
		$title = esc_attr($instance['title']);
		$americanexpress = esc_attr($instance['americanexpress']);
		$bitcoin = esc_attr($instance['bitcoin']);
		$cash_on_delivery = esc_attr($instance['cash_on_delivery']);
		$dankort = esc_attr($instance['dankort']);
		$discover = esc_attr($instance['discover']);
		$google = esc_attr($instance['google']);
		$maestro = esc_attr($instance['maestro']);
		$mastercard = esc_attr($instance['mastercard']);
		$paypal = esc_attr($instance['paypal']);
		$visa = esc_attr($instance['visa']);
		?>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('title'));?>"><?php esc_html_e('Title:', 'dazzling'); ?></label><input class="widefat" id="<?php echo esc_attr($this->get_field_id('title'));?>" name="<?php echo esc_attr($this->get_field_name('title'));?>" type="text" value="<?php echo esc_attr($title);?>" />
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['americanexpress'], true) ?> id="<?php echo esc_attr($this->get_field_id('americanexpress')); ?>" name="<?php echo esc_attr($this->get_field_name('americanexpress')); ?>"  value="<?php echo esc_attr($americanexpress);?>" /><label for="<?php echo esc_attr($this->get_field_id('americanexpress')); ?>">American Express</label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['bitcoin'], true) ?> id="<?php echo esc_attr($this->get_field_id('bitcoin')); ?>" name="<?php echo esc_attr($this->get_field_name('bitcoin')); ?>"  value="<?php echo esc_attr($bitcoin);?>" /><label for="<?php echo esc_attr($this->get_field_id('bitcoin')); ?>">Bitcoin</label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['cash_on_delivery'], true) ?> id="<?php echo esc_attr($this->get_field_id('cash_on_delivery')); ?>" name="<?php echo esc_attr($this->get_field_name('cash_on_delivery')); ?>"  value="<?php echo esc_attr($cash_on_delivery);?>" /><label for="<?php echo esc_attr($this->get_field_id('cash_on_delivery')); ?>">Cash On Delivery</label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['dankort'], true) ?> id="<?php echo esc_attr($this->get_field_id('dankort')); ?>" name="<?php echo esc_attr($this->get_field_name('dankort')); ?>"  value="<?php echo esc_attr($dankort);?>" /><label for="<?php echo esc_attr($this->get_field_id('dankort')); ?>">Dankort</label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['discover'], true) ?> id="<?php echo esc_attr($this->get_field_id('discover')); ?>" name="<?php echo esc_attr($this->get_field_name('discover')); ?>"  value="<?php echo esc_attr($discover);?>" /><label for="<?php echo esc_attr($this->get_field_id('discover')); ?>">Discover</label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['google'], true) ?> id="<?php echo esc_attr($this->get_field_id('google')); ?>" name="<?php echo esc_attr($this->get_field_name('google')); ?>"  value="<?php echo esc_attr($google);?>" /><label for="<?php echo esc_attr($this->get_field_id('google')); ?>">Google</label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['maestro'], true) ?> id="<?php echo esc_attr($this->get_field_id('maestro')); ?>" name="<?php echo esc_attr($this->get_field_name('maestro')); ?>"  value="<?php echo esc_attr($maestro);?>" /><label for="<?php echo esc_attr($this->get_field_id('maestro')); ?>">Maestro</label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['mastercard'], true) ?> id="<?php echo esc_attr($this->get_field_id('mastercard')); ?>" name="<?php echo esc_attr($this->get_field_name('mastercard')); ?>"  value="<?php echo esc_attr($mastercard);?>" /><label for="<?php echo esc_attr($this->get_field_id('mastercard')); ?>">Mastercard</label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['paypal'], true) ?> id="<?php echo esc_attr($this->get_field_id('paypal')); ?>" name="<?php echo esc_attr($this->get_field_name('paypal')); ?>"  value="<?php echo esc_attr($paypal);?>" /><label for="<?php echo esc_attr($this->get_field_id('paypal')); ?>">Paypal</label>
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['visa'], true) ?> id="<?php echo esc_attr($this->get_field_id('visa')); ?>" name="<?php echo esc_attr($this->get_field_name('visa')); ?>"  value="<?php echo esc_attr($visa);?>" /><label for="<?php echo esc_attr($this->get_field_id('visa')); ?>">Visa</label>
		</p>
		<?php
	}
}
function AcceptedPaymentWidget_Intit_Widget(){
	return register_widget('AcceptedPaymentWidget');
}
add_action('widgets_init', 'AcceptedPaymentWidget_Intit_Widget');
// end BlogWidget
?>